// $Id: chardefs.h,v 1.15 2004/08/25 19:34:26 jeffs Exp $
// $Log: chardefs.h,v $
// Revision 1.15  2004/08/25 19:34:26  jeffs
// changed back values - to have 13 descriptions
//
// Revision 1.14  2004/08/25 19:22:16  jeffs
// 1 less character description in creation screen
//
// Revision 1.13  2004/05/28 15:30:34  garys
// CHARPART_BODYTEXTURE -> CHARPART_CLOTHINGTEXTURE
//
// Revision 1.12  2004/05/26 03:03:18  jdarby
// new model description textures split into face and body textures
// added two more categories of models, hats and accessories
// 11:00 P.M.
//
// Revision 1.11  2004/05/12 15:35:02  outlaw
// max char message length
//
// Revision 1.10  2004/04/16 18:27:56  garys
// removed 'lower body' textures, fixed texture cache, txtr.ctl, and chardesc.cfg accordingly,
// changed optmenus to display current dude w/ selection items, lost character in options top menu
//
// Revision 1.9  2004/04/13 14:02:36  garys
// CharacterObject lost all InstancedObjects; models are now Global arrays
//
// Revision 1.8  2004/04/02 22:29:21  garys
// added support for custom hiar - can be a model or a texture/bump in the head
//
// Revision 1.7  2004/04/02 16:21:26  garys
// body skin defs
//
// Revision 1.6  2004/04/01 22:49:20  garys
// lost the notion of gender
//
// Revision 1.5  2004/03/31 23:20:39  garys
// Lost the Parts list in CharacterObject; now its just arrays of values - much simplier code...
//
// Revision 1.4  2004/03/31 16:40:56  garys
// defines for faces
//
// Revision 1.3  2004/03/26 22:47:00  jdarby
// character flag category defines for determining how to handle a control update
//
// Revision 1.2  2004/03/26 19:53:45  garys
// FACE
//
// Revision 1.1  2004/03/26 16:41:22  garys
// defines used by code and cfg
//

#ifndef LLPORT_H
#include <llport.h>
#endif

#ifndef CHARDEFS_H
#define CHARDEFS_H

_GENID("$Id: chardefs.h,v 1.15 2004/08/25 19:34:26 jeffs Exp $",_chardefs_h);

#define CHARCATEGORY_GENDER 0
#define CHARCATEGORY_PART   1

// some parts are gender specific
#define CHARBODYTYPE_ANY    0

// For sake of simplicity, these should be in the order that they will be rendered in
#define CHARPART_SKINTEXTURE           0
#define CHARPART_HEADTEXTURE           1
#define CHARPART_EYESTEXTURE           2
#define CHARPART_NOSETEXTURE           3
#define CHARPART_MOUTHTEXTURE          4
#define CHARPART_EYEBROWTEXTURE        5
#define CHARPART_FACIALHAIRTEXTURE     6
#define CHARPART_HAIR                  7

#define CHARPART_BODYSKINTEXTURE       8
#define CHARPART_CLOTHINGTEXTURE       9


// struct sizes from defines above
#define NUMBER_OF_FACE_TEXTURES        8
#define NUMBER_OF_BODY_TEXTURES        2

// more parts
#define CHARPART_BODY                 10

#define CHARPART_ACCESSORIES          11
#define CHARPART_HAT                  12

#define NUMBER_OF_DESCRIPTIONS  13

#define NUM_BODY_TYPES  16      // i think this is correct...
#define NUM_HAIR_TYPES  64      // guestimate

#define MAX_CHARCTER_MESSAGE_LENGTH 64

#endif // chardefs_h
