
#ifndef GSTATE_H
#define GSTATE_H

#define GAMESTATE_IDLE 1
#define GAMESTATE_REELS_SPINNING 2                          // slots only - fast spin

// poker defines
#define GAMESTATE_POST_BLIND 3 // blind bet
#define GAMESTATE_SHUFFLE 4 // self explanatory
#define GAMESTATE_DEAL_CARDS 5 // -//-
#define GAMESTATE_ACCEPT_BETS 6 // wait for everybody to bet or fold
#define GAMESTATE_SHOWDOWN 7 // showdown state in poker
#define GAMESTATE_MARK_CARDS 8 // mark cards held for swapping in draw games
#define GAMESTATE_INCREASE_BET 9 // bets gets increased from min bet to max bet
#define GAMESTATE_REELS_SLOWING_DOWN 10                     // slots only - reels slowing down
#define GAMESTATE_BUY_INSURANCE 11 // blackjack only
#define GAMESTATE_HANDLE_DEALER_BLACKJACK 12 // special blackjack step- game ends early
#define GAMESTATE_PLAY_BLACKJACK_HANDS 13
#define GAMESTATE_HANDLE_PLAYER_BLACKJACK 14
#define GAMESTATE_POST_ANTE 15
#define GAMESTATE_SELECT_SECONDARY_HAND 16
#define GAMESTATE_REVEAL_HANDS 17
#define GAMESTATE_SET_PRIORITY 18 // who goes first (poker)
#define GAMESTATE_ALLOW_DOUBLE_RAISE 19 // comes up in 7 card stud when there's a pair on 4th street
#define GAMESTATE_UPDATE_POT 20 // move side bets in front of players to center pot

// slot machine specific
#define GAMESTATE_BONUS_ROUND_INIT 20
#define GAMESTATE_BONUS_ROUND 21
#define GAMESTATE_PAYTABLE 22
#define GAMESTATE_ADD_CREDITS_TO_MACHINE 23

// 3rd arg passed to GAMESTATE_DEAL_CARDS
#define DEAL_FACE_UP 1
#define DEAL_FACE_DOWN 2
#define DEAL_TO_BOARD 3
#define DEAL_FACE_UP_TO_PLAYERS 4 // for blackjack
#define DEAL_FACE_DOWN_TO_DEALER 5 // for blackjack


// ante type for poker
#define ANTETYPE_BLINDS 1
#define ANTETYPE_ANTE 2

// hand evaluation types for poker
#define EVALTYPE_HIGH 1
#define EVALTYPE_LOW 2
#define EVALTYPE_OMAHA 4 // 2 from hand and 3 from the board

#define EVALTYPE_HIGHLOW 3
#define EVALTYPE_OMAHA_HIGH 5
#define EVALTYPE_OMAHA_HIGHLOW 7

#define SEQUENCESWITCH_NEXT_STEP 1
#define SEQUENCESWITCH_NEW_ROUND 2

// blind types in poker
#define BLINDTYPE_SMALL 1
#define BLINDTYPE_BIG 2
#define BLINDTYPE_BRINGIN 3

// argument of GAMESTATE_SET_PRIORITY that tells who goes first
#define PRIORITY_LOWEST_HAND 1
#define PRIORITY_HIGHEST_HAND 2


#define HIGH_CARD 0
#define PAIR 1
#define TWO_PAIR 2
#define THREE_OF_A_KIND 3
#define STRAIGHT 4
#define FLUSH 5
#define FULL_HOUSE 6
#define FOUR_OF_A_KIND 7
#define FIVE_OF_A_KIND 8 // used by any game with wildcards
#define STRAIGHT_FLUSH 9
#define WILD_ROYAL_FLUSH 10
#define ROYAL_FLUSH 11
#define TENS_OR_BETTER 12 // used by vid poker
#define THREE_PAIR 13 // used by paigow




#endif
