; pixel shader example - the examples below demonstrate how to define a pixel shader

; shader TEAMTINT - alpha channel of primary map lets "team color" show through.
; main shader for units without bumpmaps

PIXELSHADER TEAMTINT=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
			      "texld r0,t0"
		              "mul r0,v0,r0"
        	              "lrp r0.rgb,1-r0.a,c0,r0"
			      "mov r0.a,c0.a"
		      )	
		     )	
	 ))


PIXELSHADER NOLIGHT=
(PIX11=	(
	 (shadercode (
		      "ps.1.1"
		      "tex t0"
		      "mov r0,t0"
		      )	
		     )	
	 ))


PIXELSHADER TINT_C0=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
			      "texld r0,t0"
			      "mul r0.rgb,v0_x2,r0"
		              "mul r0.rgb,c0,r0"
		      )	
		     )	
	 ))



PIXELSHADER TEAMTIA=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
			      "def c1,0,0,0,0.5f"
                              "texld r0,t0"
		              "mul r0,v0,r0"
        	              "lrp r0.rgb,1-r0.a,c0,r0"
			      "mov r0.a,c1.a"
		      )	
		     )	
	 ))


PIXELSHADER TEAMT3=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
			      "texld r0,t0"
		              "mul r0,v0,r0"
        	              "lrp r0.rgb,1-r0.a,c0,r0"
		      )	
		     )	
	 ))

PIXELSHADER LIGHTMAP=
(PIX14=( 
	 (shadercode (
		      "ps.1.4"
		      "texld r0,t0"
	              "texld r3,t3"
                      "texld r2,t0"
                      "texld r1,t1"
		      "dp4 r3,r2,r3_bx2"
	              "mad r1.rgb,r1,r3,r1"
		      "mul r0.rgb,r0,r1_x2"
		      )
		     )
	 ))

PIXELSHADER ADD4=
(PIX14=( 
	 (shadercode (
		      "ps.1.4"
		      "texld r0,t0"
		      "texld r1,t1"
		      "texld r2,t2"
		      "texld r3,t3"
		      "mul r0.rgb,r0,v1.x"
                      "mad r0.r,r1,v1.y,r0"
                      "mad r0.g,r2,v1.z,r0"
                      "mad r0.b,r3,v1.w,r0"
		      "mul r0,c6,r0"
		      )
		     )
	 ))

PIXELSHADER SLGHTMAP=
(PIX14=( 
	 (shadercode (
		      "ps.1.4"
		      "def c3,0.1,0.1,0.1,0"
		      "def c2,0,0.125,0,0"
		      "texld r0,t0"
		      "texld r1,t1"
		      "texld r2,t2"
		      "texld r3,t3"
		      "texcrd r5.xyz,t3"
                      "sub r0.x,r0.x,r5.z"
                      "sub r1.x,r1.x,r5.z"
                      "sub r2.x,r2.x,r5.z"
                      "sub r3.x,r3.x,r5.z"
		      "cmp r1.x,r1.x,c2.x,r1.y"
		      "cmp r2.x,r2.x,c2.x,r2.y"
		      "phase"
		      "cmp r3.x,r3.x,c2.x,r3.y"
		      "cmp r0.a,r0.x,c2.x,r0.y"
		      "add r0.a,r0.a,r1.x"
		      "add r0.a,r0.a,r2.x"
		      "add r0.a,r0.a,r3.x"
		      "mov r0.xyz,c3"
                      )
		     )
	 ))


; shader TEAMT1 - alpha channel of primary map lets "team color" show through
; MAP1.R controls lighting (255=unlit,0=lit, in between gives partial lighting)
PIXELSHADER TEAMT1=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
			      "def c1,1.0f,1.0f,1.0f,1.0f"
			      "texld r0,t0"
		              "texld r1,t0"
                              "lrp r1.rgb,r1.r,c1,v0"
        	              "lrp r0.rgb,1-r0.a,c0,r0"
                              "mul r0.rgb,r1,r0"
			      "mov r0.a,c0.a"
		      )	
		     )	
	 ))


; shader TEAMT2 - alpha channel of primary map lets "team color" show through
; MAP1.R controls lighting (255=unlit,0=lit, in between gives partial lighting)
; MAP1.G adds reflection (0=no reflection, 255=full reflection)
; ENVMAP 2 must be specified to use reflection
; NOTE - in order for this shader to be used, you also need to include the line
; "TCINDEX 1 0" in the texture def.

PIXELSHADER TEAMT2=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
			      "def c1,1.0f,1.0f,1.0f,1.0f"
                              "def c2,1.0f,1.0f,1.0f,0.65f"
		              "texld r1,t0"
			      "texld r0,t0"
                              "texld r2,t2"
			      "mul r2.rgb,r1.g,r2"
	                      "lrp r1.r,r1.r,c1,v0"
        	              "lrp r0.rgb,1-r0.a,c0,r0"
			      "mul r0.rgb,r1.r,r0"
			      "add r0.rgb,r0,r2"
                              "mov r0.a,c1.a"
		      )	
		     )	
	 ))


PIXELSHADER TEAMT2A=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
			      "def c1,1.0f,1.0f,1.0f,1.0f"
                              "def c2,1.0f,1.0f,1.0f,0.65f"
		              "texld r1,t0"
			      "texld r0,t0"
                              "texld r2,t2"
			      "mul r2.rgb,r1.g,r2"
	                      "lrp r1.r,r1.r,c1,v0"
        	              "lrp r0.rgb,1-r0.a,c0,r0"
			      "mul r0.rgb,r1.r,r0"
			      "add r0.rgb,r0,r2"
                              "mov r0.a,c2.a"
		      )	
		     )	
	 ))



PIXELSHADER CHROME=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
		              "texld r1,t1"
			      "texld r0,t0"
			"mul r0,r1,r0"
 	                      "add r0,r1,r0"
		      )	
		     )	
	 ))

PIXELSHADER TINTREFL=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
		      "def c1,0.5f,0.5f,0.5f,0.8f"
		      "texld r0,t0"
		      "texld r2,t2"
		      "mul r0.rgb,r0,v0"
		      "mul r2,r2,r2"
;		      "mul r2,r2,r0"
 	              "add r0.rgb,r2,r0"
                      "mov r0.a,c1.a"
		      )	
		     )	
	 ))

PIXELSHADER ALPHREFL=
(PIX11=	(
	 (shadercode (
		      "ps.1.1"
		      "def c1,0.5f,0.5f,0.5f,1.0f"
		      "tex t0"
		      "tex t1"
		      "mov r0,t0"
		      "mov r1,t1"
		      "mul r1.rgb,r1,r0.a"
		      "add r0.rgb,r0,r1"
                      "mov r0.a,c1.a"
		      )	
		     )	
	 ))

PIXELSHADER DARKEN50=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
		       "def c1,0.5,0,0,0"
		       "texld r0,t0"
		       "mul r0.rgb,r0,c1.x"
	))))

PIXELSHADER FLAME=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
		       "def c0,0.04,0.04,0,0"
                       "texcrd r0.rgb,t0"
                       "texcrd r5.rgb,t5"
			"texld r1,t1"
			"texld r2,t2"
			"texld r3,t3"
			"add r1.xy,r1_bx2,r2_bx2"
			"add r1.xy,r1,r3_bx2"
			"mul r1.xy,r1,c0"
                        "add r0.xy,r0,r1"
                        "phase"
                        "texld r0,r0"
;			"mul r0.rgb,r5,r0"
			"mul r0,c6,r0"
	))))

PIXELSHADER FLAME2=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
		       "def c0,0.2,0.3,0,0"
                       "texcrd r0.rgb,t0"
                       "texcrd r5.rgb,t5"
			"texld r1,t1"
			"texld r2,t2"
			"texld r3,t3"
			"add r1.xy,r1_bx2,r2_bx2"
			"add r1.xy,r1,r3_bx2"
			"mul r1.xy,r1,c0"
                        "mul r1.xy,1-r5,r1"
			"add r0.xy,r0,r1"
                        "phase"
                        "texld r0,r0"
			"mul r0.rgb,r5,r0"
			"mul r0.rgb,r5,r0"
			"mul r0.rgb,v0,r0"
	))))

PIXELSHADER FLAME1=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
		       "def c0,0.2,0.3,0,0"
                       "texcrd r0.rgb,t0"
                       "texcrd r5.rgb,t5"
			"texld r1,t1"
			"texld r2,t2"
			"texld r3,t3"
			"add r1.xy,r1_bx2,r2_bx2"
			"add r1.xy,r1,r3_bx2"
			"mul r1.xy,r1,c0"
                        "mul r1.xy,1-r5,r1"
			"add r0.xy,r0,r1"
                        "phase"
                        "texld r0,r0"
			"mul r0.rgb,r5,r0"
			"mul r0.rgb,r5,r0"
	))))

PIXELSHADER FLAME3=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
		       "def c1,0.1,0.1,0,0"
                       "texcrd r0.rgb,t0"
                       "texcrd r5.rgb,t5"
			"texld r1,t1"
			"texld r2,t2"
			"texld r3,t3"
			"add r1.xy,r1_bx2,r2_bx2"
			"add r1.xy,r1,r3_bx2"
			"mul r1.xy,r1,c1"
                        "mul r1.xy,1-r5,r1"
			"add r0.xy,r0,r1"
                        "phase"
                        "texld r0,r0"
			"mul r0.xyz,r0,c0"       ; team tint
	))))

PIXELSHADER FLAME4=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
		       "def c1,0.1,0.1,0,0"
                       "texcrd r0.rgb,t0"
                       "texcrd r5.rgb,t5"
			"texld r1,t1"
			"texld r2,t2"
			"texld r3,t3"
			"add r1.xy,r1_bx2,r2_bx2"
			"add r1.xy,r1,r3_bx2"
			"mul r1.xy,r1,c1"
                        "mul r1.xy,1-r5,r1"
			"add r0.xy,r0,r1"
                        "phase"
                        "texld r0,r0"
			"mul r0.xyz,r0,c0"       ; team tint
			"mov r0.a,r5.x"

	))))

PIXELSHADER EFLAME=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
		       "def c0,0.2,0.3,0,0"
                       "texcrd r0.rgb,t0"
                       "texcrd r5.rgb,t5"
			"texld r1,t1"
			"texld r2,t2"
			"texld r3,t3"
			"add r1.xy,r1_bx2,r2_bx2"
			"add r1.xy,r1,r3_bx2"
			"mul r1.xy,r1,c0"
                        "mul r1.xy,1-r5,r1"
			"add r0.xy,r0,r1"
                        "phase"
                        "texld r0,r0"
			"mul r0.rgb,1-r5,r0"
			"mul r0.rgb,1-r5,r0"
			"mul r0.rgb,1-r5,r0"
			"mul r0.rgb,1-r5,r0"
			"mul r0.rgb,1-r5,r0"
	))))

; shader DOT3 - map1=color+alpha
;               map2=bump map in dot3 format. alpha in bump map lets team color show through
;               model using must be exported with binormals and tangents
;  VSHADER 0 FLOAT3 1 FLOAT3 2 FLOAT2 3 FLOAT3 4 FLOAT3 :vshaders/bumpm.vsh should be used

PIXELSHADER DOT3=
(PIX14=	(
	 (shadercode (
					; t0=normal
					; t1=tangent
					; t2=binormal
					; t3=base texture
		      "ps.1.4"
		      "def c1,0,0,0,1"
		      "def c2,0.9f,0.7f,0.91f,0.5"      ; sky color
		      "def c3,0.238f,0.357f,0.218f,0"      ; ground color
		      "texcrd r2.xyz,t2"          ; N
                      "texcrd r3.xyz,t3"          ;T
		      "texcrd r4.xyz,t4"          ;B
                      "texld  r1,t1"          ; BUMP
                      "mul r4.xyz,r4,r1_bx2.x"
                      "mad r4.xyz,r2,r1_bx2.z,r4"
                      "mad r4.xyz,r3,r1_bx2.y,r4"
                      "mul r5.x,r4.y,c2.w"
                      "add r5.x,r5,c2.w"
                      "lrp r5.rgb,r5.x,c2,c3"
                      "phase"
                      "texld  r0,t0"          ; base
       		      "lrp r0.rgb,1-r0.a,c0,r0"
                      "dp3 r4.x,r4,c7"
		      "cmp r4.x,r4.x,r4.x,c1.x"
		      "mad r4.rgb,r5_x2,c7.a,r4.x"
		      "mul r0.xyz,r4,r0"
;		      "mov r0.rgb,r5"
                      "mov r0.a,c1.a"
                      )
		     )	
	 ))

PIXELSHADER DOT3A=
(PIX14=	(
	 (shadercode (
					; t0=normal
					; t1=tangent
					; t2=binormal
					; t3=base texture
		      "ps.1.4"
		      "def c1,0,0,0,1"
		      "texcrd r2.xyz,t2"          ; N
                      "texcrd r3.xyz,t3"          ;T
		      "texcrd r4.xyz,t4"          ;B
                      "texld  r1,t1"          ; BUMP
                      "texld  r0,t0"          ; base
       		      "lrp r0.rgb,1-r0.a,c0,r0"
		      "mul r4.xyz,r4,r1_bx2.x"
                      "mad r4.xyz,r2,r1_bx2.z,r4"
                      "mad r4.xyz,r3,r1_bx2.y,r4"
                      "mov r1.x,r0.a"
                      "phase"
                      "dp3 r4.x,r4,c7"
		      "cmp r4.x,r4.x,r4.x,c1.x"
		      "add r4.x,c7.a,r4.x"
		      "mul r0.xyz,r4.x,r0"
                      "mov r0.a,r1.x"
                       )
		     )	
	 ))

PIXELSHADER DOT3B=
(PIX14=	(
	 (shadercode (
					; t0=normal
					; t1=tangent
					; t2=binormal
					; t3=base texture
		      "ps.1.4"
		      "def c1,0,0,0,1"
		      "texcrd r2.xyz,t2"          ; N
                      "texcrd r3.xyz,t3"          ;T
		      "texcrd r4.xyz,t4"          ;B
                      "texld  r1,t1"          ; BUMP
                      "texld  r0,t0"          ; base
       		      "lrp r0.rgb,1-r0.a,c0,r0"
		      "mul r4.xyz,r4,r1_bx2.x"
                      "mad r4.xyz,r2,r1_bx2.z,r4"
                      "mad r4.xyz,r3,r1_bx2.y,r4"
                      "mov r1.x,r1.a"
                      "phase"
                      "dp3 r4.x,r4,c7"
		      "cmp r4.x,r4.x,r4.x,c1.x"
		      "add r4.x,c7.a,r4.x"
		      "mul r0.xyz,r4.x,r0"
                      "mov r0.a,r1.x"
                       )
		     )	
	 ))

PIXELSHADER GENSHAD=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
		      "def c1,1, 0.125f, 1, 1"
		      "texcrd r0.xyz,t0.xyz"          ; N
		      "mov r0.a,c1.a"
		      "mov r0.g,c1.g"
		      )	
		     )	
	 ))

PIXELSHADER PSCONST6=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
		      "mov r0,c6"
		      )	
		     )	
	 ))

#define REFLECTIONMAPPED VSHADER 40 CONST4 -.4 .4 .5 0 0 FLOAT3 1 FLOAT3 2 FLOAT2 3 FLOAT3 4 FLOAT3 :vshaders/reflm.vsh

PIXELSHADER UVSHOW=
(PIX14=	(
	 (shadercode (
		      "ps.1.4"
		      "def c1,1,1,1,1"
		      "texcrd r0.xyz,t0.xyz"
		      "mov r0,r0.x"
		      "mov r0.a,c1.x"
		      )	
		     )	
	 ))


; shader DOT3REF - bumpmapped w/ team color + reflections
;               map0=color+team color %
;               map1=bump map in dot3 format. alpha in bump map is reflection amount
;               model using must be exported with binormals and tangents
;  VSHADER 0 FLOAT3 1 FLOAT3 2 FLOAT2 3 FLOAT3 4 FLOAT3 :vshaders/bumpm.vsh should be used
; also MAP2 smapr.tga
PIXELSHADER DOT3REF=
(PIX14=	(
	 (shadercode (
					; t0=normal
					; t1=tangent
					; t2=binormal
					; t3=base texture
		      "ps.1.4"
		      "def c1,0.5f,0.4f,0,1"
		      "texcrd r2.xyz,t2"          ; N
                      "texcrd r3.xyz,t3"          ;T
		      "texcrd r4.xyz,t4"          ;B
                      "texld  r1,t1"          ; BUMP
       		      "texcrd r5.xyz,t5"
		      "mul r4.xyz,r4,r1_bx2.x"
                      "mad r4.xyz,r2,r1_bx2.z,r4"
                      "mad r4.xyz,r3,r1_bx2.y,r4"
                      "dp3 r0,r4,r5"           ;r0=n.i
                      "mul r1.xyz,r4,r0"       ;(n.i)*n
                      "sub r0.xyz,r5,r1_x2"       ;i-(n.i)*n
	              "mad r0.xyz,r0,c1.g,c1.r"
                      "mov r5.x,r1.a"
	              "phase"
		      "texld r2,r0"
                      "texld  r0,t0"          ; base
       		      "lrp r0.rgb,1-r0.a,c0,r0"
                      "dp3 r4.x,r4,c7"
		      "cmp r4.x,r4.x,r4.x,c1.z"
		      "add r4.x,c7.a,r4.x"
		      "mul r0.xyz,r4.x,r0"
		      "mad r0.xyz,r2,r5.x,r0"
                      "mov r0.a,c1.a"
                      )
		     )	
	 ))

PIXELSHADER DOTCHRM=
(PIX14=	(
	 (shadercode (
					; t0=normal
					; t1=tangent
					; t2=binormal
					; t3=base texture
		      "ps.1.4"
		      "def c1,0.5f,0.4f,0,1"
		      "texcrd r2.xyz,t2"          ; N
                      "texcrd r3.xyz,t3"          ;T
		      "texcrd r4.xyz,t4"          ;B
                      "texld  r1,t1"          ; BUMP
       		      "texcrd r5.xyz,t5"
		      "mul r4.xyz,r4,r1_bx2.x"
                      "mad r4.xyz,r2,r1_bx2.z,r4"
                      "mad r4.xyz,r3,r1_bx2.y,r4"
                      "dp3 r0,r4,r5"           ;r0=n.i
                      "mul r1.xyz,r4,r0"       ;(n.i)*n
                      "sub r0.xyz,r5,r1_x2"       ;i-(n.i)*n
	              "mad r0.xyz,r0,c1.g,c1.r"
                      "mov r5.x,r1.a"
	              "phase"
		      "texld r2,r0"
                      "texld  r0,t0"          ; base
                      "mul r2.xyz,r0,r2"
                      "dp3 r4.x,r4,c7"
		      "cmp r4.x,r4.x,r4.x,c1.z"
		      "add r4.x,c7.a,r4.x"
		      "mul r0.xyz,r4.x,r0"
		      "mad r0.xyz,r2,r5.x,r0"
                      )
		     )	
	 ))

PIXELSHADER FASTBUMP=
(PIX11=	(
	 (shadercode (
					; t0=base
					; t1=bump
		      "ps.1.1"
		      "def c1,0.5,0.5,0.5,1"
		      "tex t0"
                      "tex t1"          ; BUMP
		      "texcoord t3"          ; btn.l
		      "dp3 r1,t3,t1_bx2"
		      "mad r1.xyz,r1,c1,c1"
		      "mov r0,t0"
                      "mul r0.xyz,r1,r0"
                      )
		     )	
	 ))

; like fastbump except pays attention to alpha
PIXELSHADER FASTBMPA=
(PIX14=	(
	 (shadercode (
					; t0=base
					; t1=bump
					; t2=(b,t,n).l
		      "ps.1.4"
		      "def c1,0.5,0,0,1"
		      "texcrd r2.xyz,t3"          ; btn.l
                      "texld  r1,t1"          ; BUMP
		      "dp3 r4.x,r2,r1_bx2"
                      "phase"
                      "texld  r0,t0"          ; base
		      "mul r4.x,r4,c1.x"
                      "add r4.x,r4,c1.x"
		      "mul r0.xyz,r4.x,r0"
                      )
		     )	
	 ))

PIXELSHADER SHOWTAN=
(PIX14=	(
	 (shadercode (
					; t0=normal
					; t1=tangent
					; t2=binormal
					; t3=base texture
		      "ps.1.4"
		      "def c1,0.5f,0,0,1"
		      "texcrd r2.xyz,t2"          ; N
                      "texcrd r3.xyz,t3"          ;T
		      "texcrd r4.xyz,t4"          ;B
                      "texld  r1,t1"          ; BUMP
                      "phase"
                      "texld  r0,t0"          ; base
       		      "lrp r0.rgb,1-r0.a,c0,r0"
                      "mul r0.xyz,r3,c1.x"
                      "add r0.xyz,r0,c1.x"
		      "mov r0.a,c1.a"
                      )
		     )	
	 ))


; FBMPOCC - fast bump map shader with occlusion term in 3rd map
PIXELSHADER FBMPOCC=
(PIX11=	(
	 (shadercode (
					; t0=base
					; t1=bump
					; t2=(b,t,n).l
		      "ps.1.1"
		      "def c1,0.5,0.5,0.5,1"
		      "def c2,1,0,0,0"
		      "def c3,0,1,0,0"
		      "tex t0"
                      "tex t1"          ; BUMP
		      "tex t2"          ; occlusion
		      "texcoord t3"          ; btn.l
		      "dp3 r1,t3,t1_bx2"
		      "dp3 r0,t2,c2"    ; grab red channel for oclusion
		      "mad r1.xyz,r1,c1,c1"
 		      "mul r1.xyz,r1,r0"
		      "mov r0,t0"
                      "mul r0.xyz,r1,r0"
		      "dp3 r1.xyz,c3,t2"
		      "add r0.xyz,r0,r1"
                      )
		     )	
	 ))

PIXELSHADER EDGEHL=
(PIX14=	(
	 (shadercode (
					; t0=base texture
					; t1=bump map
					; t2=normal
					; t3=tangent
					; t4=binormal
		      "ps.1.4"
;		      "def c1,0.55f,0.45f,0.45f,1"
		      "def c1,1,1,1,1"
                      "texld  r1,t1"          ; BUMP
		      "texcrd r2.xyz,t2"          ; N
                      "texcrd r3.xyz,t3"          ;T
		      "texcrd r4.xyz,t4"          ;B
		      "texcrd r0.xyz,t5"          ;V
		      "mul r4.xyz,r4,r1_bx2.x"
                      "mad r4.xyz,r2,r1_bx2.z,r4"
                      "mad r4.xyz,r3,r1_bx2.y,r4"
             	      "dp3 r4.x,r0,r4"
	     	      "mul r4.r,r4,r4"
		      "phase"
                      "texld  r0,t0"          ; base
		      "sub r4.x,c1.a,r4.x"
		      "mul r4.x,r4,r4"
		      "mul r4.x,r4,r4"
		      "mul r4.xyz,r4.x,c1"
   		      "mul r0.xyz,r0,r4"
		       )
		     )	
	 ))
