#if _XBOX
#define D3DTSS_ADDRESSU                0  ; D3DTEXTUREADDRESS for U coordinate
#define D3DTSS_ADDRESSV                1  ; D3DTEXTUREADDRESS for V coordinate
#define D3DTSS_ADDRESSW                2  ; D3DTEXTUREADDRESS for W coordinate
#define D3DTSS_MAGFILTER               3  ; D3DTEXF_LINEAR etc. filter to use for magnification
#define D3DTSS_MINFILTER               4  ; D3DTEXF_LINEAR etc. filter to use for minification
#define D3DTSS_MIPFILTER               5  ; D3DTEXF_LINEAR etc. filter to use between mipmaps during minification
#define D3DTSS_MIPMAPLODBIAS           6  ; float mipmap LOD bias
#define D3DTSS_MAXMIPLEVEL             7  ; DWORD 0..(n-1) LOD index of largest map to use (0 == largest)
#define D3DTSS_MAXANISOTROPY           8  ; DWORD maximum anisotropy
#define D3DTSS_COLORKEYOP              9  ; D3DTEXTURECOLORKEYOP (Xbox extension)
#define D3DTSS_COLORSIGN              10  ; D3DTSIGN_ASIGNED etc. for signed color channels (xbox extension)
#define D3DTSS_ALPHAKILL              11  ; D3DTEXTUREALPHAKILL (Xbox extension)

#define D3DTSS_DEFERRED_TEXTURE_STATE_MAX = 12,

#define D3DTSS_COLOROP                12  ; D3DTEXTUREOP - per-stage blending controls for color channels
#define D3DTSS_COLORARG0              13  ; D3DTA_TEXTURE etc. - third arg for triadic ops
#define D3DTSS_COLORARG1              14  ; D3DTA_TEXTURE etc. - texture arg
#define D3DTSS_COLORARG2              15  ; D3DTA_TEXTURE etc. - texture arg
#define D3DTSS_ALPHAOP                16  ; D3DTEXTUREOP - per-stage blending controls for alpha channel
#define D3DTSS_ALPHAARG0              17  ; D3DTA_TEXTURE etc. - third arg for triadic ops
#define D3DTSS_ALPHAARG1              18  ; D3DTA_TEXTURE etc. - texture arg
#define D3DTSS_ALPHAARG2              19  ; D3DTA_TEXTURE etc. - texture arg)
#define D3DTSS_RESULTARG              20  ; D3DTA_CURRENT or D3DTA_TEMP - arg for result
#define D3DTSS_TEXTURETRANSFORMFLAGS  21  ; D3DTEXTURETRANSFORMFLAGS controls texture transform

#define D3DTSS_DEFERRED_MAX           22

; State that has immediate processing:

#define D3DTSS_BUMPENVMAT00          22  ; float (bump mapping matrix)
#define D3DTSS_BUMPENVMAT01          23  ; float (bump mapping matrix)
#define D3DTSS_BUMPENVMAT11          24  ; float (bump mapping matrix)
#define D3DTSS_BUMPENVMAT10          25  ; float (bump mapping matrix)
#define D3DTSS_BUMPENVLSCALE         26  ; float scale for bump map luminance
#define D3DTSS_BUMPENVLOFFSET        27  ; float offset for bump map luminance
#define D3DTSS_TEXCOORDINDEX         28  ; DWORD identifies which set of texture coordinates index this texture
#define D3DTSS_BORDERCOLOR           29  ; D3DCOLOR
#define D3DTSS_COLORKEYCOLOR         30  ; D3DCOLOR value for color key (Xbox extension)

#define D3DTSS_MAX                   32  ; Total number of texture stage states (bumped to a power of 2)

#else

#define D3DTSS_COLOROP          1 ; D3DTEXTUREOP - per-stage blending controls for color channels
#define D3DTSS_COLORARG1        2 ; D3DTA_* (texture arg)
#define D3DTSS_COLORARG2        3 ; D3DTA_* (texture arg)
#define D3DTSS_ALPHAOP          4 ; D3DTEXTUREOP - per-stage blending controls for alpha channel
#define D3DTSS_ALPHAARG1        5 ; D3DTA_* (texture arg)
#define D3DTSS_ALPHAARG2        6 ; D3DTA_* (texture arg)
#define D3DTSS_BUMPENVMAT00     7 ; D3DVALUE (bump mapping matrix)
#define D3DTSS_BUMPENVMAT01     8 ; D3DVALUE (bump mapping matrix)
#define D3DTSS_BUMPENVMAT10     9 ; D3DVALUE (bump mapping matrix)
#define D3DTSS_BUMPENVMAT11    10 ; D3DVALUE (bump mapping matrix)
#define D3DTSS_TEXCOORDINDEX   11 ; identifies which set of texture coordinates index this texture
#define D3DTSS_ADDRESS         12 ; D3DTEXTUREADDRESS for both coordinates
#define D3DTSS_ADDRESSU        13 ; D3DTEXTUREADDRESS for U coordinate
#define D3DTSS_ADDRESSV        14 ; D3DTEXTUREADDRESS for V coordinate
#define D3DTSS_BORDERCOLOR     15 ; D3DCOLOR
#define D3DTSS_MAGFILTER       16 ; D3DTEXTUREMAGFILTER filter to use for magnification
#define D3DTSS_MINFILTER       17 ; D3DTEXTUREMINFILTER filter to use for minification
#define D3DTSS_MIPFILTER       18 ; D3DTEXTUREMIPFILTER filter to use between mipmaps during minification
#define D3DTSS_MIPMAPLODBIAS   19 ; D3DVALUE Mipmap LOD bias
#define D3DTSS_MAXMIPLEVEL     20 ; DWORD 0..(n-1) LOD index of largest map to use (0  largest)
#define D3DTSS_MAXANISOTROPY   21 ; DWORD maximum anisotropy
#define D3DTSS_BUMPENVLSCALE   22 ; D3DVALUE scale for bump map luminance
#define D3DTSS_BUMPENVLOFFSET  23 ; D3DVALUE offset for bump map luminance

#endif

#define D3DTOP_DISABLE    1     ; disables stage
#define D3DTOP_SELECTARG1 2     ; the default
#define D3DTOP_SELECTARG2 3
#define D3DTOP_MODULATE   4     ; multiply args together
#define D3DTOP_MODULATE2X 5     ; multiply and  1 bit
#define D3DTOP_MODULATE4X 6     ; multiply and  2 bits

#define D3DTOP_ADD           7  ; add arguments together
#define D3DTOP_ADDSIGNED     8  ; add with -0.5 bias
#define D3DTOP_ADDSIGNED2X   9  ; as above but left  1 bit
#define D3DTOP_SUBTRACT     10  ; Arg1 - Arg2with no saturation
#define D3DTOP_ADDSMOOTH    11  ; add 2 argssubtract product
                                ; Arg1 + Arg2 - Arg1*Arg2
                                ; Arg1 + (1-Arg1)*Arg2

; Linear alpha blend: Arg1*(Alpha) + Arg2*(1-Alpha)
#define D3DTOP_BLENDDIFFUSEALPHA    12 ; iterated alpha
#define D3DTOP_BLENDTEXTUREALPHA    13 ; texture alpha
#define D3DTOP_BLENDFACTORALPHA     14 ; alpha from D3DRENDERSTATE_TEXTUREFACTOR
; Linear alpha blend with pre-multiplied arg1 input: Arg1 + Arg2*(1-Alpha)
#define D3DTOP_BLENDTEXTUREALPHAPM  15 ; texture alpha
#define D3DTOP_BLENDCURRENTALPHA    16 ; by alpha of current color

; Specular mapping
#define D3DTOP_PREMODULATE            17    ; modulate with next texture before use
#define D3DTOP_MODULATEALPHA_ADDCOLOR 18    ; Arg1.RGB + Arg1.A*Arg2.RGB
                                            ; COLOROP only
#define D3DTOP_MODULATECOLOR_ADDALPHA 19    ; Arg1.RGB*Arg2.RGB + Arg1.A
                                            ; COLOROP only
#define D3DTOP_MODULATEINVALPHA_ADDCOLOR 20 ; (1-Arg1.A)*Arg2.RGB + Arg1.RGB
                                            ; COLOROP only
#define D3DTOP_MODULATEINVCOLOR_ADDALPHA 21 ; (1-Arg1.RGB)*Arg2.RGB + Arg1.A
                                            ; COLOROP only

; Bump mapping
#define D3DTOP_BUMPENVMAP           22 ; per pixel env map perturbation
#define D3DTOP_BUMPENVMAPLUMINANCE  23 ; with luminance channel
    ; This can do either diffuse or specular bump mapping with correct input.
    ; Performs the function (Arg1.R*Arg2.R + Arg1.G*Arg2.G + Arg1.B*Arg2.B)
    ; where each component has been scaled and offset to make it signed.
    ; The result is replicated into all four (including alpha) channels.
    ; This is a valid COLOROP only.
#define D3DTOP_DOTPRODUCT3          24


#define D3DTA_SELECTMASK        15  ; mask for arg selector
#define D3DTA_DIFFUSE           0  ; select diffuse color
#define D3DTA_CURRENT           1  ; select result of previous stage
#define D3DTA_TEXTURE           2  ; select texture color
#define D3DTA_TFACTOR           3  ; select RENDERSTATE_TEXTUREFACTOR
#define D3DTA_SPECULAR          4  ; select specular color
#define D3DTA_COMPLEMENT        16  ; take 1.0 - x
#define D3DTA_ALPHAREPLICATE    32  ; replicate alpha to color components

