// $Id: hedge.vsh,v 1.1 2004/05/18 18:53:48 chrisg Exp $
// $Log: hedge.vsh,v $
// Revision 1.1  2004/05/18 18:53:48  chrisg
// new shader for ceace
//

// this vertex shader is for bump mapping and reflections
// feeds:
// t0=base texture coord
// t1=bump map texture coord
// t2=world space normal
// t3=world space tangent
// t4=world space binmormal
// t5=normalized eye vector in world space
//

#define POS_IN v0
#define NORMAL_IN v1
#define UV_IN v2
#define TANGENT_IN v3

vs.1.0
m4x4 oPos, POS_IN, COMPOSITE_MATRIX   // transform vertices by view/projection matrix
m4x4 r1,NORMAL_IN,WORLDMATRIX_WITHOUT_TRANSLATION       // transform normal into world space
mov oT2.xyz,r1
m4x4 r2,TANGENT_IN,WORLDMATRIX_WITHOUT_TRANSLATION       // transform tangent into world space
mov oT3.xyz,r2
mul r0,r1.yzxw,r2.zxyw
mad r0,-r2.yzxw,r1.zxyw,r0
mov oT4.xyz,r0
mov oT0.xy,UV_IN
mov oT1.xy,UV_IN
// now, calculate normalized eye point
m4x4 r3,POS_IN,MODEL_TO_WORLD_MATRIX
sub r3.xyz,r3,WORLD_SPACE_VIEW_POSITION
dp3 r3.w,r3,r3
rsq r3.w,r3.w
mul oT5.xyz,r3,r3.w
